<?php

declare(strict_types=1);

namespace Doctrine\Inflector\Rules\English;

use Doctrine\Inflector\Rules\Pattern;

final class Uninflected
{
    /** @return Pattern[] */
    public static function getSingular(): iterable
    {
        yield from self::getDefault();

        yield new Pattern('.*ss');
        yield new Pattern('clothes');
        yield new Pattern('data');
        yield new Pattern('fascia');
        yield new Pattern('fuchsia');
        yield new Pattern('galleria');
        yield new Pattern('mafia');
        yield new Pattern('militia');
        yield new Pattern('pants');
        yield new Pattern('petunia');
        yield new Pattern('sepia');
        yield new Pattern('trivia');
        yield new Pattern('utopia');
    }

    /** @return Pattern[] */
    public static function getPlural(): iterable
    {
        yield from self::getDefault();

        yield new Pattern('people');
        yield new Pattern('trivia');
        yield new Pattern('\w+ware$');
        yield new Pattern('media');
    }

    /** @return Pattern[] */
    private static function getDefault(): iterable
    {
        yield new Pattern('\w+media');
        yield new Pattern('absence');
        yield new Pattern('access');
        yield new Pattern('accommodation');
        yield new Pattern('adulthood');
        yield new Pattern('advertising');
        yield new Pattern('advice');
        yield new Pattern('aggression');
        yield new Pattern('agriculture');
        yield new Pattern('aid');
        yield new Pattern('air');
        yield new Pattern('aircraft');
        yield new Pattern('alcohol');
        yield new Pattern('amoyese');
        yield new Pattern('anger');
        yield new Pattern('applause');
        yield new Pattern('arithmetic');
        yield new Pattern('art');
        yield new Pattern('assistance');
        yield new Pattern('atmosphere');
        yield new Pattern('attention');
        yield new Pattern('audio');
        yield new Pattern('bacon');
        yield new Pattern('baggage');
        yield new Pattern('ballet');
        yield new Pattern('beauty');
        yield new Pattern('beef');
        yield new Pattern('beer');
        yield new Pattern('behavior');
        yield new Pattern('biology');
        yield new Pattern('bison');
        yield new Pattern('blood');
        yield new Pattern('borghese');
        yield new Pattern('botany');
        yield new Pattern('bravery');
        yield new Pattern('bread');
        yield new Pattern('bream');
        yield new Pattern('breeches');
        yield new Pattern('britches');
        yield new Pattern('buffalo');
        yield new Pattern('business');
        yield new Pattern('butter');
        yield new Pattern('cake');
        yield new Pattern('cantus');
        yield new Pattern('carbon');
        yield new Pattern('carp');
        yield new Pattern('cash');
        yield new Pattern('cattle');
        yield new Pattern('chaos');
        yield new Pattern('chassis');
        yield new Pattern('cheese');
        yield new Pattern('chess');
        yield new Pattern('childhood');
        yield new Pattern('chocolate');
        yield new Pattern('clamp');
        yield new Pattern('clippers');
        yield new Pattern('clothing');
        yield new Pattern('coal');
        yield new Pattern('cod');
        yield new Pattern('coffee');
        yield new Pattern('coitus');
        yield new Pattern('commerce');
        yield new Pattern('compensation');
        yield new Pattern('confidence');
        yield new Pattern('confusion');
        yield new Pattern('congoese');
        yield new Pattern('content');
        yield new Pattern('contretemps');
        yield new Pattern('cookery');
        yield new Pattern('coreopsis');
        yield new Pattern('corps');
        yield new Pattern('corruption');
        yield new Pattern('cotton');
        yield new Pattern('countryside');
        yield new Pattern('courage');
        yield new Pattern('crockery');
        yield new Pattern('cutlery');
        yield new Pattern('damage');
        yield new Pattern('dancing');
        yield new Pattern('danger');
        yield new Pattern('darkness');
        yield new Pattern('data');
        yield new Pattern('debris');
        yield new Pattern('deer');
        yield new Pattern('delight');
        yield new Pattern('democracy');
        yield new Pattern('depression');
        yield new Pattern('designs');
        yield new Pattern('dessert');
        yield new Pattern('determination');
        yield new Pattern('diabetes');
        yield new Pattern('dignity');
        yield new Pattern('dirt');
        yield new Pattern('distribution');
        yield new Pattern('djinn');
        yield new Pattern('driving');
        yield new Pattern('dust');
        yield new Pattern('duty');
        yield new Pattern('earth');
        yield new Pattern('economics');
        yield new Pattern('education');
        yield new Pattern('eland');
        yield new Pattern('elk');
        yield new Pattern('emoji');
        yield new Pattern('employment');
        yield new Pattern('engineering');
        yield new Pattern('entertainment');
        yield new Pattern('enthusiasm');
        yield new Pattern('environment');
        yield new Pattern('envy');
        yield new Pattern('equipment');
        yield new Pattern('ethics');
        yield new Pattern('evidence');
        yield new Pattern('evil');
        yield new Pattern('evolution');
        yield new Pattern('existence');
        yield new Pattern('expense');
        yield new Pattern('failure');
        yield new Pattern('faith');
        yield new Pattern('fame');
        yield new Pattern('faroese');
        yield new Pattern('fashion');
        yield new Pattern('fear');
        yield new Pattern('feedback');
        yield new Pattern('fiction');
        yield new Pattern('finance');
        yield new Pattern('fire');
        yield new Pattern('fish');
        yield new Pattern('flesh');
        yield new Pattern('flounder');
        yield new Pattern('flour');
        yield new Pattern('flu');
        yield new Pattern('foochowese');
        yield new Pattern('food');
        yield new Pattern('forgiveness');
        yield new Pattern('freedom');
        yield new Pattern('friendship');
        yield new Pattern('fruit');
        yield new Pattern('fuel');
        yield new Pattern('fun');
        yield new Pattern('furniture');
        yield new Pattern('gallows');
        yield new Pattern('garbage');
        yield new Pattern('garlic');
        yield new Pattern('gasoline');
        yield new Pattern('genetics');
        yield new Pattern('genevese');
        yield new Pattern('genoese');
        yield new Pattern('gilbertese');
        yield new Pattern('glass');
        yield new Pattern('gold');
        yield new Pattern('golf');
        yield new Pattern('gossip');
        yield new Pattern('grammar');
        yield new Pattern('grass');
        yield new Pattern('gratitude');
        yield new Pattern('grief');
        yield new Pattern('ground');
        yield new Pattern('growth');
        yield new Pattern('guilt');
        yield new Pattern('gymnastics');
        yield new Pattern('hair');
        yield new Pattern('happiness');
        yield new Pattern('hardware');
        yield new Pattern('harm');
        yield new Pattern('hate');
        yield new Pattern('headquarters');
        yield new Pattern('health');
        yield new Pattern('height');
        yield new Pattern('help');
        yield new Pattern('herpes');
        yield new Pattern('hijinks');
        yield new Pattern('history');
        yield new Pattern('homework');
        yield new Pattern('honesty');
        yield new Pattern('honey');
        yield new Pattern('hope');
        yield new Pattern('hospitality');
        yield new Pattern('hottentotese');
        yield new Pattern('housework');
        yield new Pattern('humor');
        yield new Pattern('hunger');
        yield new Pattern('hydrogen');
        yield new Pattern('ice');
        yield new Pattern('ice cream');
        yield new Pattern('imagination');
        yield new Pattern('impatience');
        yield new Pattern('importance');
        yield new Pattern('independence');
        yield new Pattern('industry');
        yield new Pattern('inflation');
        yield new Pattern('information');
        yield new Pattern('infrastructure');
        yield new Pattern('injustice');
        yield new Pattern('innings');
        yield new Pattern('innocence');
        yield new Pattern('insurance');
        yield new Pattern('intelligence');
        yield new Pattern('iron');
        yield new Pattern('irony');
        yield new Pattern('jackanapes');
        yield new Pattern('jam');
        yield new Pattern('jealousy');
        yield new Pattern('jeans');
        yield new Pattern('jedi');
        yield new Pattern('jewelry');
        yield new Pattern('joy');
        yield new Pattern('judo');
        yield new Pattern('juice');
        yield new Pattern('justice');
        yield new Pattern('karate');
        yield new Pattern('kin');
        yield new Pattern('kindness');
        yield new Pattern('kiplingese');
        yield new Pattern('knowledge');
        yield new Pattern('kongoese');
        yield new Pattern('labor');
        yield new Pattern('lack');
        yield new Pattern('land');
        yield new Pattern('laughter');
        yield new Pattern('lava');
        yield new Pattern('leather');
        yield new Pattern('leisure');
        yield new Pattern('lightning');
        yield new Pattern('linguistics');
        yield new Pattern('literature');
        yield new Pattern('litter');
        yield new Pattern('livestock');
        yield new Pattern('logic');
        yield new Pattern('loneliness');
        yield new Pattern('love');
        yield new Pattern('lucchese');
        yield new Pattern('luck');
        yield new Pattern('luggage');
        yield new Pattern('machinery');
        yield new Pattern('mackerel');
        yield new Pattern('magic');
        yield new Pattern('mail');
        yield new Pattern('maltese');
        yield new Pattern('management');
        yield new Pattern('mankind');
        yield new Pattern('marble');
        yield new Pattern('marriage');
        yield new Pattern('mathematics');
        yield new Pattern('mayonnaise');
        yield new Pattern('measles');
        yield new Pattern('meat');
        yield new Pattern('mercy');
        yield new Pattern('metadata');
        yield new Pattern('metal');
        yield new Pattern('methane');
        yield new Pattern('mews');
        yield new Pattern('milk');
        yield new Pattern('mist');
        yield new Pattern('money');
        yield new Pattern('moonlight');
        yield new Pattern('moose');
        yield new Pattern('motherhood');
        yield new Pattern('motivation');
        yield new Pattern('mud');
        yield new Pattern('mumps');
        yield new Pattern('music');
        yield new Pattern('nankingese');
        yield new Pattern('nature');
        yield new Pattern('news');
        yield new Pattern('nexus');
        yield new Pattern('niasese');
        yield new Pattern('nitrogen');
        yield new Pattern('nutrition');
        yield new Pattern('obedience');
        yield new Pattern('offspring');
        yield new Pattern('oil');
        yield new Pattern('oxygen');
        yield new Pattern('parking');
        yield new Pattern('passion');
        yield new Pattern('patience');
        yield new Pattern('pekingese');
        yield new Pattern('pepper');
        yield new Pattern('permission');
        yield new Pattern('piedmontese');
        yield new Pattern('pincers');
        yield new Pattern('pistoiese');
        yield new Pattern('plankton');
        yield new Pattern('pliers');
        yield new Pattern('poetry');
        yield new Pattern('pokemon');
        yield new Pattern('police');
        yield new Pattern('polish');
        yield new Pattern('portuguese');
        yield new Pattern('proceedings');
        yield new Pattern('progress');
        yield new Pattern('psychology');
        yield new Pattern('quartz');
        yield new Pattern('rabies');
        yield new Pattern('racism');
        yield new Pattern('rain');
        yield new Pattern('reliability');
        yield new Pattern('relief');
        yield new Pattern('research');
        yield new Pattern('respect');
        yield new Pattern('rhinoceros');
        yield new Pattern('rice');
        yield new Pattern('safety');
        yield new Pattern('salad');
        yield new Pattern('salmon');
        yield new Pattern('salt');
        yield new Pattern('sand');
        yield new Pattern('sarawakese');
        yield new Pattern('satire');
        yield new Pattern('satisfaction');
        yield new Pattern('scaffolding');
        yield new Pattern('scenery');
        yield new Pattern('scissors');
        yield new Pattern('sea[- ]bass');
        yield new Pattern('seaside');
        yield new Pattern('series');
        yield new Pattern('sewing');
        yield new Pattern('shavese');
        yield new Pattern('shears');
        yield new Pattern('sheep');
        yield new Pattern('shopping');
        yield new Pattern('siemens');
        yield new Pattern('silk');
        yield new Pattern('sms');
        yield new Pattern('snow');
        yield new Pattern('soap');
        yield new Pattern('social media');
        yield new Pattern('software');
        yield new Pattern('soil');
        yield new Pattern('sorrow');
        yield new Pattern('spam');
        yield new Pattern('species');
        yield new Pattern('spite');
        yield new Pattern('staff');
        yield new Pattern('steam');
        yield new Pattern('stream');
        yield new Pattern('strength');
        yield new Pattern('sugar');
        yield new Pattern('swine');
        yield new Pattern('talent');
        yield new Pattern('tea');
        yield new Pattern('technology');
        yield new Pattern('temperature');
        yield new Pattern('tennis');
        yield new Pattern('thirst');
        yield new Pattern('tolerance');
        yield new Pattern('toothpaste');
        yield new Pattern('trade');
        yield new Pattern('traffic');
        yield new Pattern('transportation');
        yield new Pattern('travel');
        yield new Pattern('trouble');
        yield new Pattern('trousers');
        yield new Pattern('trout');
        yield new Pattern('trust');
        yield new Pattern('tuna');
        yield new Pattern('understanding');
        yield new Pattern('underwear');
        yield new Pattern('unemployment');
        yield new Pattern('unity');
        yield new Pattern('us');
        yield new Pattern('usage');
        yield new Pattern('validity');
        yield new Pattern('veal');
        yield new Pattern('vegetarianism');
        yield new Pattern('vegetation');
        yield new Pattern('vengeance');
        yield new Pattern('vermontese');
        yield new Pattern('vinegar');
        yield new Pattern('violence');
        yield new Pattern('vision');
        yield new Pattern('warmth');
        yield new Pattern('water');
        yield new Pattern('wealth');
        yield new Pattern('weather');
        yield new Pattern('weight');
        yield new Pattern('welfare');
        yield new Pattern('wenchowese');
        yield new Pattern('wheat');
        yield new Pattern('whiting');
        yield new Pattern('width');
        yield new Pattern('wildebeest');
        yield new Pattern('wildlife');
        yield new Pattern('wisdom');
        yield new Pattern('wood');
        yield new Pattern('wool');
        yield new Pattern('yeast');
        yield new Pattern('yengeese');
        yield new Pattern('yoga');
        yield new Pattern('youth');
        yield new Pattern('zinc');
        yield new Pattern('zoology');
    }
}
