# Docker support

Besides generating a PHAR, you may want to create a [Docker][docker] image for your application. To do so, you can
either:

- Directly generate the `Dockerfile` when generating the PHAR with the `--with-docker` option of the Box `compile` 
  command
- Generate the `Dockerfile` for a given PHAR with the Box `docker` command

The command will attempt to generate a `Dockerfile` for your PHAR, leveraging the 
[requirement checker][requirement-checker]. Once the file generated, you have free hands on it: you can either use it 
right away (you just need to run `$ docker build .` to create the docker image) or you can tweak it however you want.

In your `Dockerfile` (generated by Box), you should see the following line:

```Dockerfile
RUN $(php -r '$extensionInstalled = array_map("strtolower", \get_loaded_extensions(false));$requiredExtensions = ["zlib", "phar", "openssl", "pcre", "tokenizer"];$extensionsToInstall = array_diff($requiredExtensions, $extensionInstalled);if ([] !== $extensionsToInstall) {echo \sprintf("docker-php-ext-install %s", implode(" ", $extensionsToInstall));}echo "echo \"No extensions\"";')
``` 

This cryptic one-liner PHP script is about installing the required extensions for your application: it compares the ones
your application requires with the ones already provided by the base PHP image, and then install them using the
[`docker-php-ext-install`][docker-php-ext-install] command. It is however possible that this fails for various reason:
the extension is not a known one, it cannot be installed the traditional way, it needs to be compiled with PHP... For
all those cases (unless you have a better way to handle it in which case PRs are welcomed) you will have to dirty your
hands and tweak the `Dockerfile` to your needs.

<br />
<hr />

« [PHAR code isolation](code-isolation.md#phar-code-isolation) • [Table of Contents](../README.md#table-of-contents) »


[docker]: https://www.docker.com/
[docker-php-ext-install]: https://docs.docker.com/samples/library/php/
[requirement-checker]: requirement-checker.md#requirements-checker
