<?php

declare(strict_types=1);

/*
 * This file is part of the box project.
 *
 * (c) Kevin Herrera <kevin@herrera.io>
 *     Théo Fidry <theo.fidry@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace KevinGH\Box\Configuration;

use RuntimeException;
use Throwable;

/**
 * @private
 */
final class NoConfigurationFound extends RuntimeException
{
    /**
     * {@inheritdoc}
     */
    public function __construct(string $message = 'The configuration file could not be found.', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }
}
